/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
head_score();

/**
 * Performs the head score calculation for the specified models
 */
function head_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head`;

    let occupants = ["DRIVER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        let capping_limit_explanation = "";
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */

        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head score and modifiers */
            let head_hic_score;
            let head_hic_capping_limit;
            let head_tms_exc_score;
            let head_tms_exc_capping_limit;
            let head_modifier;

            switch (occ) {
                case "DRIVER":
                    head_hic_score = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
                    head_hic_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_HIC_CAPPING_LIMIT`);
                    head_tms_exc_score = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`,
                        "float"
                    );
                    head_tms_exc_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_CAPPING_LIMIT`
                    );
                    head_modifier = get_variable_value(
                        status,
                        `${m}_${occ}_AIRBAG_DYNAMIC_PROTECTION_PERFORMANCE_MODIFIER`,
                        "float"
                    );
                    break;
                case "REAR_DRIVER_SIDE":
                    head_hic_score = get_variable_value(status, `${m}_${occ}_HEAD_HIC_REAR_PASSENGER_SCORE`, "float");
                    head_hic_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_HIC_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    head_tms_exc_score = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_REAR_PASSENGER_SCORE`,
                        "float"
                    );
                    head_tms_exc_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    head_modifier = get_variable_value(
                        status,
                        `${m}_${occ}_AIRBAG_DYNAMIC_PROTECTION_PERFORMANCE_MODIFIER`,
                        "float"
                    );
                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let head_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let head_capping_limit = "*";
            
            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                head_score = Math.max(0, Math.min(head_tms_exc_score, head_hic_score) + head_modifier);

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */
                if (head_hic_capping_limit == "" && head_tms_exc_capping_limit == "") {
                    head_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Overall scores */
            let head_score_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_FINAL_SCORE`,
                "Final head score",
                head_score.toString(),
                "String",
                false,
                true
            );
            /* Capping limits */
            let head_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_CAPPING_LIMIT`,
                "Head capping limit (*asterisk if limit exceeded; empty string otherwise)",
                head_capping_limit,
                "String",
                false,
                true
            );
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_HEAD_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
